<header>
  <div class="logo">The Menus Online</div>
  <div class="menu-toggle" id="toggle">
    <span></span>
    <span></span>
    <span></span>
  </div>
  <nav id="nav">
    <a href="/">Home</a>
    <a href="/about">About</a>
    <a href="/contact">Contact</a>
  </nav>
</header>

<style>
  header {
    background: #222;
    color: white;
    padding: 1rem 2rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: relative;
  }

  .logo {
    font-size: 1.5rem;
    font-weight: bold;
  }

  nav {
    display: flex;
    gap: 1.5rem;
  }

  nav a {
    color: white;
    text-decoration: none;
    font-weight: 500;
  }

  .menu-toggle {
    display: none;
    flex-direction: column;
    cursor: pointer;
    gap: 5px;
  }

  .menu-toggle span {
    width: 25px;
    height: 3px;
    background: white;
    display: block;
  }

  @media (max-width: 768px) {
    nav {
      display: none;
      flex-direction: column;
      background: #222;
      position: absolute;
      top: 100%;
      right: 0;
      width: 100%;
      text-align: right;
      padding: 1rem 2rem;
    }

    nav.open {
      display: flex;
    }

    .menu-toggle {
      display: flex;
    }
  }
</style>

<script>
  document.addEventListener('DOMContentLoaded', () => {
    const toggle = document.getElementById('toggle');
    const nav = document.getElementById('nav');

    toggle.addEventListener('click', () => {
      nav.classList.toggle('open');
    });
  });
</script>
